# include file for GURPS Spirits.

$$argtype(paths, list, "Path Defaults", "Choose the default paths and indicate the default value: Path of Cunning-7. Click Add to add the value.",
	", ", "?list:Skills:Ritual Path|*")

$$argtype(rituals, list, "Rituals", "Choose a ritual to add to the Path. Click Add to add the value.",
	";", "?list:Skills:Ritual|*")


$$macro ritualmod(name, init)
{{
$$macrodesc("Ritual modifier")
$$argdesc(name, "Name of modifier")

	$$item($(name))
	level "$(init)"
	formula 0
	checkexp x<=0
	varname "$$exp("replaceString(name, '/[^a-zA-Z]/', '')")"
	editdlg 3
	format "%0ln%-12r!--%-5rv"
	sformat %0ln
}}


$$macro path(name, rituals)
{{
$$macrodesc("Ritual Path")
$$argdesc(name, "Name of path (Cunning, Knowledge)")
$$argdesc(rituals: rituals, "List of rituals for the path (separated by semicolons)")

	$$skill("Path of $(name)", MVH!, "Esoteric;*Ritual Path", RitualMagic-6,
		"Skills:Ritual Magic>=IQ-3::Must spend 1 point on Ritual Magic;Additional Attributes:Ritual Modifier", ,
		"pathcost(~x)", "pathchk(x,c)")
	$$ifdef(rituals)
		autochargecost dontmarkauto deleteauto noautodup
		autoitems "Sublist[Rituals];?open;$(rituals);?close"
	$$endif
	opt	exp "Effective Skill" "max(0,havePathApt(itemInfo('@n@'))?x:x+RitualModifier+RitualAptitude)"
		end
}}


$$macro ritual(name, pathdefs)
{{
$$macrodesc("Ritual macro")
$$argdesc(name, "Ritual name")
$$argdesc(pathdefs: paths, "List of path defaults, separated by commas (Path of Cunning-4, Path of Knowledge-4")

	$$item($(name))
	cat Ritual
	prereq "$$repeat($(pathdefs),d,' *, *', "|")Skills:$$exp("replaceString(d,'/[^A-Za-z ]/','')")$$endrepeat"
	varname "$$exp("replaceString(name, '/[^a-zA-Z]/', '')")"
	format "%0ln%-18ll%-12rc%-7rx|dsk(@v@)|"
	sformat "%0ln%-10r!Ritual"
	checkexp "ritualchk(x,c,max($$exp("replaceString(pathdefs,'/[^-a-zA-Z0-9,]/','')")),max($$exp("replaceString(pathdefs,'/[^a-zA-Z,]/','')")))"
	level "max($$exp("replaceString(pathdefs,'/[^-a-zA-Z0-9,]/','')"))"
	formula "x<=0?0:2*(x-max($$exp("replaceString(pathdefs,'/[^-a-zA-Z0-9,]/','')")))"

	opt	exp "Effective Skill" "max(0,haveSingleRitApt(itemInfo('@n@'))$$repeat($(pathdefs),d,' *, *') or havePathApt('$$exp("replaceString(d,'/[^A-Za-z ]/','')")')$$endrepeat?x:x+RitualModifier+RitualAptitude)"
		end
}}

